<?php //{{MediaWikiExtension}}<source lang="php">
/*
 * ArticleComments.php - A MediaWiki extension for adding comment sections to articles.
 * @author Jim R. Wilson, James Moore
 * @version 0.4.4
 * @copyright Copyright (C) 2007 Jim R. Wilson
 * @license The MIT License - http://www.opensource.org/licenses/mit-license.php 
 * -----------------------------------------------------------------------
 * Description:
 *     This is a MediaWiki (http://www.mediawiki.org/) extension which adds support
 *     for comment sections within article pages, or directly into all pages.
 * Requirements:
 *     MediaWiki 1.6.x, 1.8.x, 1.9.x or higher (including 1.20wmf10)
 *     PHP 4.x, 5.x or higher
 * Installation:
 *     1. Drop this script (ArticleComments.php) in $IP/extensions
 *         Note: $IP is your MediaWiki install dir.
 *     2. Enable the extension by adding this line to your LocalSettings.php:
 *            require_once('extensions/ArticleComments.php');
 * Usage:
 *     Once installed, you may utilize ArticleComments by adding the following flag in the article text:
 *         <comments />
 *     Note: Typically this would be placed at the end of the article text.
 *
 *
 * Tip: 
 *     To show the comment form in the footer of every page in the main and Talk namespaces, install 
 *     the Header_Footer extension (http://www.mediawiki.org/wiki/Extension:Header_Footer) then add 
 *     "<comments />" to your "/wiki/MediaWiki:Hf-nsfooter-" and "/wiki/MediaWiki:Hf-nsfooter-Talk" pages.
 *
 * Version Notes:
 *     version 0.4.4:
 *         Updated to be compatible with MediaWiki 1.20wmf10
 *     version 0.4.3:
 *         Added new insertion feature, comments will now be inserted before <!--COMMENTS_ABOVE--> if present
 *         Or, after <!--COMMENTS_BELOW--> if present (the latter causes reverse chronological comment ordering).
 *     version 0.4.2:
 *         Updated default spam filtering code to check all fields against $wgSpamRegex, if specified.
 *     version 0.4.1:
 *         Updated default spam filtering code. (now matches <a> tags in commenterName)
 *     version 0.4:
 *         Updated default spam filtering code.
 *         Abstracted Spam filter via hook (ArticleCommentsSpamCheck) to aid future spam checkers
 *     version 0.3:
 *         Added rudimentary spam filtering based on common abuses.
 *     version 0.2:
 *         Fixed form post method to use localized version of "Special"
 *         Added option for making the form automatically visible (no "Leave a comment..." link)
 *         Added option of diabling the "Website" field
 *         Added system message for prepopulating the comment box.
 *         Added system message for structuring comment submission text.
 *         Added abstracted method for form creation (for insertion into skins)
 *         Added option to "Whitelist" Namespaces for comment submission (as by skin-level form).
 *         Added check for user blocked status prior to comment submission.
 *     version 0.1:
 *         Initial release.
 * -----------------------------------------------------------------------
 * Copyright (c) 2007 Jim R. Wilson
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights to 
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
 * the Software, and to permit persons to whom the Software is furnished to do 
 * so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all 
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
 * OTHER DEALINGS IN THE SOFTWARE. 
 * -----------------------------------------------------------------------
 */
 
// Confirm MW environment
if (!defined('MEDIAWIKI')) die();
 
// Credits
$wgExtensionCredits['other'][] = array(
    'name'=>'ArticleComments',
    'author'=>array('Jim R. Wilson','James G. T. Moore'),
    'url'=>'http://jimbojw.com/wiki/index.php?title=ArticleComments',
    'description'=>'Enables a comment form on article pages.',
    'version'=>'0.4.4'
);

$dir = dirname( __FILE__ ) . '/';

# Default values for most options
$wgArticleCommentsDefaults = array();
// To show the text input box for the Url 
$wgArticleCommentsDefaults['showurlfield'] = false;
// To show the text input box for the town and country
$wgArticleCommentsDefaults['showtowncountryfield'] = false;
// To globally display the comment form by default set this to false:
$wgArticleCommentsDefaults['hideform'] = true;
// To disable the comment form for anonymous users set this to true
$wgArticleCommentsDefaults['disableanon'] = true;

// Register files
$wgAutoloadClasses['ArticleCommentsHooks'] = $dir . 'ArticleComments.hooks.php'; // ArticleCommentsHooks class
$wgAutoloadClasses['SpecialProcessComment'] = $dir . 'SpecialProcessComment.php'; // SpecialProcessComment class

// Load internationalisation file
$wgExtensionMessagesFiles['ArticleComments'] = $dir . 'ArticleComments.i18n.php';
$wgExtensionMessagesFiles['ArticleCommentsAlias'] = $dir . 'ArticleComments.alias.php'; 

// Configure special page
$wgSpecialPages['ProcessComment'] = 'SpecialProcessComment'; # Tell MediaWiki about the new special page and its class name
$wgSpecialPageGroups['ProcessComment'] = 'other'; # Specify which section on the Special:Version page should it's meta data be displayed.

// Add Extension Functions
//$wgExtensionFunctions[] = 'wfArticleCommentsParserSetup';
// When the ParserFirstCallInit event triggers, execute the onParserSetup function
$wgHooks['ParserFirstCallInit'][] = 'ArticleCommentsHooks::onParserSetup';
// When the ParserAfterTidyevent triggers, execute the onProcessEncodedContent function
$wgHooks['ParserAfterTidy'][] = 'ArticleCommentsHooks::onProcessEncodedContent';
$wgHooks['BeforePageDisplay'][] = 'ArticleCommentsHooks::beforePageDisplay';

$wgResourceModules['ext.ArticleComments'] = array(
        // JavaScript and CSS styles. To combine multiple files, just list them as an array.
        //'scripts' => 'ext.ArticleComments.form.js',
        'styles' => 'ext.ArticleComments.form.css',
 
        // When your module is loaded, these messages will be available through mw.msg()
        //'messages' => array( 'myextension-hello-world', 'myextension-goodbye-world' ),
 
        // If your scripts need code from other modules, list their identifiers as dependencies
        // and ResourceLoader will make sure they're loaded before you.
        // You don't need to manually list 'mediawiki' or 'jquery', which are always loaded.
        //'dependencies' => array( 'jquery.ui.datepicker' ),
 
        // You need to declare the base path of the file paths in 'scripts' and 'styles'
        'localBasePath' => dirname( __FILE__ ) . '/modules',
        // ... and the base from the browser as well. For extensions this is made easy,
        // you can use the 'remoteExtPath' property to declare it relative to where the wiki
        // has $wgExtensionAssetsPath configured:
        'remoteExtPath' => 'ArticleComments/modules'
);